package cn.com.duiba.quanyi.center.api.enums.template;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * 特殊字段
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum TemplateFieldCodeEnum {

    ROOT("root", "根对象字段code"),

    ARRAY_ITEM_SUFFIX("ArrayItem", "数组固定子节点code结尾"),

    ;
    /**
     * 类型
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 获取数组固定子节点code
     *
     * @param fieldCode 域代码
     * @return {@link String }
     */
    public static String getArrayItemFieldCode(String fieldCode) {
        return fieldCode + ARRAY_ITEM_SUFFIX.getCode();
    }

}
