package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayActivityBillDownloadStatusEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AlipayActivityBillDownloadRecordEntityParam extends PageQuery {
    private static final long serialVersionUID = -2681188260834778096L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 开始时间：格式：2020-01-01 00:00:00
     */
    private Date startTime;

    /**
     * 结束时间：格式：2020-01-01 00:00:00
     */
    private Date endTime;

    /**
     * 账单申请id
     */
    private String billId;

    /**
     * 账单类型：
     * cn.com.duiba.supplier.channel.service.api.enums.alipay.AlipayBillBizTypeEnum
     */
    private String billType;

    /**
     * 账单类型集合
     * cn.com.duiba.supplier.channel.service.api.enums.alipay.AlipayBillBizTypeEnum
     */
    private List<String> billTypeList;

    /**
     * 额外信息
     */
    private String extra;

    /**
     * 状态 0-未使用，1-使用
     * {@link AlipayActivityBillDownloadStatusEnum}
     */
    private Integer bizStatus;
}
