package cn.com.duiba.quanyi.center.api.param.bigdata;

import cn.com.duiba.quanyi.center.api.enums.bigdata.BigdataHologresTableEnum;
import cn.com.duiba.quanyi.center.api.enums.bigdata.QueryOperatorTypeEnum;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeGrantParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeSplitParam;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author lizhi
 * @date 2024/3/5 13:55
 */
@Data
public class BigdataHologresDownloadParam implements Serializable {
    
    private static final long serialVersionUID = -6648475263099236277L;

    /**
     * 数据库表名称
     * @see cn.com.duiba.quanyi.center.api.enums.bigdata.BigdataHologresTableEnum
     */
    private String tableName;

    /**
     * 过滤条件
     */
    private List<BigdataQueryConditionParam> filterConditions;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 指定文件名称，如果为空则走默认文件名称
     */
    private String fileName;

    /**
     * 查询字段名称
     */
    private List<BigdataQueryFieldParam> queryFields;


    /**
     * 分表字段
     */
    private String shardField;

    /**
     * 二级组合过滤条件
     */
    private List<BigdataComboQueryConditionParam> filterConditionComboLists;

    private static final String DATE_PARTITION = "date_partition";

    public Object getStartDataPartition(){
        if(CollectionUtils.isEmpty(filterConditions)){
            return null;
        }
        for(BigdataQueryConditionParam param : filterConditions){
            if(Objects.equals(param.getFieldName(), DATE_PARTITION) && Objects.equals(param.getSymbol(), QueryOperatorTypeEnum.GE.toString())){
                return param.getFieldValue().get(0);
            }
        }
        return null;
    }


    public Object getEndDataPartition(){
        if(CollectionUtils.isEmpty(filterConditions)){
            return null;
        }
        for(BigdataQueryConditionParam param : filterConditions){
            if(Objects.equals(param.getFieldName(), DATE_PARTITION) && Objects.equals(param.getSymbol(), QueryOperatorTypeEnum.LE.toString())){
                return param.getFieldValue().get(0);
            }
        }
        return null;
    }


    public List<Object> getEndDataPartition(String key){
        if(CollectionUtils.isEmpty(filterConditions)){
            return null;
        }
        for(BigdataQueryConditionParam param : filterConditions){
            if(Objects.equals(param.getFieldName(), key)){
                return param.getFieldValue();
            }
        }
        return null;
    }
}
