package cn.com.duiba.quanyi.center.api.param.mail;

import java.io.File;
import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 邮件发送请求参数
 * 
 * @author yangyukang
 * @date 2025-09-24 17:30
 */
@Data
public class MailSendRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 发送人邮箱地址
     */
    private String fromEmail;

    /**
     * 接收人邮箱地址列表
     */
    private List<String> toEmails;

    /**
     * 抄送邮箱地址列表（可选）
     */
    private List<String> ccEmails;

    /**
     * 密送邮箱地址列表（可选）
     */
    private List<String> bccEmails;

    /**
     * 邮件主题
     */
    private String subject;

    /**
     * 邮件内容
     */
    private String content;

    /**
     * 邮件内容是否为HTML格式，默认false
     */
    private Boolean isHtml = false;

    /**
     * 附件文件列表（可选）
     */
    private List<File> attachments;
}
