package cn.com.duiba.quanyi.center.api.remoteservice.contract;

import java.util.List;
import java.util.Set;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractConsumeStatDto;
import cn.com.duiba.quanyi.center.api.param.contract.ContractOccupyAmountUpdateParam;

/**
 * 合同消耗统计RemoteService
 *
 * @author xuzhigang
 * @date 2025-06-06
 */
@AdvancedFeignClient
public interface RemoteContractConsumeStatService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 合同消耗统计
     */
    ContractConsumeStatDto selectById(Long id);

    /**
     * 根据统计ID和统计类型查询
     *
     * @param statId   统计ID
     * @param statType 统计类型
     * @return 合同消耗统计
     */
    ContractConsumeStatDto selectByStatIdAndType(Long statId, Integer statType);

    /**
     * 根据多个统计ID和指定统计类型查询
     *
     * @param statIds  统计ID集合
     * @param statType 统计类型
     * @return 合同消耗统计列表
     */
    List<ContractConsumeStatDto> selectByStatIdsAndType(Set<Long> statIds, Integer statType);

    /**
     * 根据是否超额查询
     *
     * @param hasOverAmount 是否超额 0-未超额 1-已超额
     * @return 合同消耗统计列表
     */
    List<ContractConsumeStatDto> selectByHasOverAmount(Integer hasOverAmount);

    /**
     * 根据统计类型和是否超额查询
     *
     * @param statType      统计类型
     * @param hasOverAmount 是否超额 0-未超额 1-已超额
     * @return 合同消耗统计列表
     */
    List<ContractConsumeStatDto> selectByStatTypeAndHasOverAmount(Integer statType, Integer hasOverAmount);

    /**
     * 新增
     *
     * @param dto 合同消耗统计
     * @return 执行结果
     */
    int insert(ContractConsumeStatDto dto);

    /**
     * 更新
     *
     * @param dto 合同消耗统计
     * @return 执行结果
     */
    int update(ContractConsumeStatDto dto);

    /**
     * 乐观锁更新占用金额（增加或减少）
     *
     * @param statId       统计ID
     * @param statType     统计类型
     * @param changeAmount 变更金额（正数表示增加，负数表示减少）
     * @param lockVersion  版本号
     * @return 执行结果
     */
    int updateOccupyAmountOptimistic(Long statId, Integer statType, Long changeAmount, Integer lockVersion);

    /**
     * 批量乐观锁更新占用金额（增加或减少）
     *
     * @param updateParams 批量更新参数列表
     * @return 执行结果
     */
    int batchUpdateOccupyAmountOptimistic(List<ContractOccupyAmountUpdateParam> updateParams);
}
