/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.equity.coupon;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum EquityCouponStateEnum {
    NOT_TAKE(1, "\u5f85\u5151\u6362"),
    TAKE_PROCESSING(2, "\u5151\u6362\u4e2d"),
    TAKE_SUCCESS(3, "\u5f85\u6838\u9500/\u5df2\u5151\u6362"),
    VERIFICATION(4, "\u5df2\u6838\u9500"),
    TAKE_EXPIRED(5, "\u5151\u6362\u8fc7\u671f"),
    VERIFICATION_EXPIRE(6, "\u6838\u9500\u8fc7\u671f"),
    INVALID(7, "\u5df2\u4f5c\u5e9f");

    private final Integer state;
    private final String desc;
    private static final Map<Integer, EquityCouponStateEnum> ENUM_MAP;

    public String logStr() {
        return this.state + "-" + this.desc;
    }

    public static EquityCouponStateEnum getByState(Integer state) {
        if (state == null) {
            return null;
        }
        return ENUM_MAP.get(state);
    }

    public Integer getState() {
        return this.state;
    }

    public String getDesc() {
        return this.desc;
    }

    private EquityCouponStateEnum(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(EquityCouponStateEnum.values()).collect(Collectors.toMap(EquityCouponStateEnum::getState, Function.identity(), (v1, v2) -> v2)));
    }
}

