package cn.com.duiba.quanyi.center.api.dto.unionpay;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 银联卡卷活动关联表
 * @author mybatis generator 
 * @date 2025-04-23
 */
@Data
public class UnionPayActivityRelationDto implements Serializable {
     
    private static final long serialVersionUID = 17453753370015484L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 银联卡卷主键, tb_union_pay_activity.id
     */
    private Long unionPayActivityId;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 活动类型：1=白名单领奖、2=兑吧卡密包
     */
    private Integer activityType;
}