package cn.com.duiba.quanyi.center.api.enums.coupon;

import java.util.Objects;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 券生效时间类型枚举
 * @author xuzhigang
 * @date 2025-06-03
 */
@Getter
@AllArgsConstructor
public enum EffectiveTimeTypeEnum {

    UNKNOWN(0, "未知"),
    IMMEDIATE(1, "立即生效"),
    NEXT_DAY(2, "第二天生效（自动化创建的批次才有）"),

    ;

    private final Integer type;

    private final String desc;

    public static EffectiveTimeTypeEnum getByType(Integer type) {
        for (EffectiveTimeTypeEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

}
