package cn.com.duiba.quanyi.center.api.enums.psbc.rs;

import lombok.Getter;

@Getter
public enum PsbcRsServiceResultEnum {


    SUCCESS(0, "处理成功"),
    AGAINST_UNIQUE_ERROR(1000, "不接受重复请求"),
    VERIFY_ERROR(1001, "验证签名失败"),
    EXIST_NO_METHOD(1002, "interfaceMethod对应的方法不存在"),
    OUT_1003(1003, "入参不规则不符合"),
    OUT_1004(1004, "该方法暂未对外提供使用"),
    OUT_1005(1005, "内部方法异常,请联系客户经理"),
    OUT_1006(1006, "未找到对应该appId密钥配置"),
    SIGN_ERROR(1007, "返回数据加签失败"),
    ENCRYPT_ERROR(1008, "返回数据加密失败"),
    DECRYPT_ERROR(1009, "数据解密失败"),

    ;
    private Integer code;
    private String tips;

    PsbcRsServiceResultEnum(Integer code, String tips) {
        this.code = code;
        this.tips = tips;
    }

    public static String getValueByCode(Integer code) {
        for (PsbcRsServiceResultEnum typeEnum : PsbcRsServiceResultEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum.getTips();
            }
        }
        return null;
    }

    public static PsbcRsServiceResultEnum getEnumByCode(Integer code) {
        for (PsbcRsServiceResultEnum typeEnum : PsbcRsServiceResultEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }
}
