package cn.com.duiba.quanyi.center.api.enums.settlement.prepayment;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/3/5 13:43
 */
@AllArgsConstructor
@Getter
public enum PrepaymentUsageRulesEnum {
    ALL(1, "项目下全部对接人可用"),
    DESIGNATED(2, "指定对接人可用")
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, PrepaymentUsageRulesEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PrepaymentUsageRulesEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static PrepaymentUsageRulesEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
