package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityExtDto;

/**
 * 活动配置扩展表
 * @author kjj mybatis generator 
 * @date 2023-12-15
 */
@AdvancedFeignClient
public interface RemoteActivityExtService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动配置扩展
     */
    ActivityExtDto selectById(Long id);

    /**
     * 根据活动id查询(有缓存)
     * @param activityId 主键
     * @return conf_name conf_value
     */
    Map<Integer, String> queryMapByActivityId(Long activityId);

    /**
     * 根据活动id查询(无缓存)
     * @param activityIds 主键
     * @return map<活动id，map<conf_name，conf_value>>
     */
    Map<Long, Map<Integer, String>> queryMapByActivityIds(List<Long> activityIds);

    /**
     * 根据唯一约束查询扩展信息（带缓存）
     * @param activityId
     * @param confName
     * @return
     */
    ActivityExtDto selectByUkWithLocal(Long activityId, Integer confName);

    /**
     * 根据唯一约束查询扩展信息（不带缓存）
     * 目前给b端使用
     * @param activityId
     * @param confName
     * @return
     */
    ActivityExtDto selectByUk(Long activityId, Integer confName);

    /**
     * 插入或者修改
     * @param activityExtDto
     * @return
     */
    Boolean saveOrUpdate(ActivityExtDto activityExtDto);

    /**
     * select by conf name and conf value
     *
     * @param confName  conf name
     * @param confValue conf value
     * @return {@link List}<{@link ActivityExtDto}>
     */
    List<ActivityExtDto> selectByConfNameAndConfValue(Integer confName, String confValue);

    /**
     * 根据活动id、confName批量查询(有缓存)
     * @param activityIds 主键
     * @param confNames 拓展信息类型
     * @return 活动拓展信息
     */
    Map<Long,Map<Integer, String>> queryMapByActivityIdsAndConfNamesCache(List<Long> activityIds, List<Integer> confNames);

    /**
     * 批量新增活动配置扩展
     * @param activityExtDtoList 活动配置扩展列表
     * @return 插入数量
     */
    Integer batchInsert(List<ActivityExtDto> activityExtDtoList);

    /**
     * 批量保存或更新活动配置扩展
     * @param activityExtDtoList 活动配置扩展列表
     * @return 影响行数
     */
    Integer batchSaveOrUpdate(List<ActivityExtDto> activityExtDtoList);
}