package cn.com.duiba.quanyi.center.api.remoteservice.pkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pkg.GoodsPkgSkuStockDto;

import java.util.List;
import java.util.Set;

/**
 * 商品包sku商品库存服务
 */
@AdvancedFeignClient
public interface RemoteGoodsPkgSkuStockService {
    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品库存
     */
    GoodsPkgSkuStockDto selectById(Long id);

    /**
     * 根据商品包skuId查询
     * @param pkgSkuId 商品包skuId
     * @return 商品库存
     */
    GoodsPkgSkuStockDto selectByPkgSkuId(Long pkgSkuId);

    /**
     * 根据商品包skuId批量查询
     * @param pkgSkuIds 商品包skuId集合
     * @return 商品库存
     */
    List<GoodsPkgSkuStockDto> selectByPkgSkuIds(Set<Long> pkgSkuIds);

    /**
     * 新增
     * @param entity 商品库存
     * @return 执行结果
     */
    Long insert(GoodsPkgSkuStockDto entity);

    /**
     * 更新
     * @param entity 商品库存
     * @return 执行结果
     */
    int update(GoodsPkgSkuStockDto entity);
}
