package cn.com.duiba.quanyi.center.api.remoteservice.workflow;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.workflow.WorkflowApprovalDetailDto;
import cn.com.duiba.quanyi.center.api.param.workflow.RefundWorkflowStartApprovalProcessParam;

/**
 * 退款审批流远程服务接口
 * @author yangyukang
 * @date 2025/1/21
 */
@AdvancedFeignClient
public interface RemoteRefundWorkflowService {

    /**
     * 发起退款审批流程
     * @param param 审批参数
     * @return 审批流实例ID
     */
    Long startRefundApprovalProcess(RefundWorkflowStartApprovalProcessParam param);

    /**
     * 获取退款审批详情
     * @param refundChangeRecordId 退款变更记录ID
     * @param refresh 是否刷新
     * @return 审批详情
     */
    WorkflowApprovalDetailDto getRefundApprovalDetail(Long refundChangeRecordId, boolean refresh);
}
