package cn.com.duiba.quanyi.center.api.dto.activity.common.result.collection;

import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonBaseUserResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonCanParticipateDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/22 09:52
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityCommonCollectionPageUserResultDto extends ActivityCommonBaseUserResultDto {

    private static final long serialVersionUID = 3824015657716216990L;

    /**
     * 是否开启报名
     */
    private Boolean enableSignedUp;

    /**
     * 是否可参与
     */
    private ActivityCommonCanParticipateDto canParticipate;

    /**
     * 用户领取统计数据表ID
     */
    private Long userTakeStatId;

    /**
     * 活动纬度已领取数量，用于校验领取记录并发写入
     */
    private Long takeCount;

    /**
     * 最后一次领取记录ID，用于校验领取记录并发写入
     */
    private Long lastRecordId;

    /**
     * 已参与的活动ID，下划线分割
     */
    private String takeActivityIds;

    /**
     * 已参与的活动ID
     */
    private List<Long> participateActivityIds;

    /**
     * 参与限制
     */
    private List<ActivityCommonParticipateLimitResultDto> participateLimit;

    /**
     * 活动列表
     */
    private List<ActivityCommonUserActivityResultDto> activityList;

}
