package cn.com.duiba.quanyi.center.api.dto.pay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuzhigang
 * @date 2025/3/20 17:44
 **/
@Data
public class PayOrderEsDto implements Serializable {
    private static final long serialVersionUID = 12047718071919447L;

    /**
     * tb_pay_order.id
     */
    private Long id;

    /**
     * 订单业务主键
     */
    private Long payBizId;

    /**
     * 订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum
     */
    private Integer payBizType;

    /**
     * 用户id
     * tb_users.id
     */
    private Long userId;

    /**
     * 支付时间
     */
    private String paidTime;

    /**
     * 支付状态
     * {@link cn.com.duiba.quanyi.center.api.enums.pay.PayStatusEnum}
     */
    private Integer payStatus;

    /**
     * 兑吧支付单号
     */
    private String bizOrderNo;

    /**
     * 渠道支付单号
     */
    private String outTradeNo;

    /**
     * 活动id
     * tb_activity.id
     */
    private Long activityId;

    /**
     * 活动名称
     * tb_activity.activity_name
     */
    private String activityName;

    /**
     * 银行用户id
     */
    private String bankUserId;

    /**
     * 扩展字段1
     */
    private String extParam1;

    /**
     * 扩展字段2
     */
    private String extParam2;

    /**
     * 扩展字段3
     */
    private String extParam3;
}
