package cn.com.duiba.quanyi.center.api.param.refund;

import java.util.Date;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 退款执行明细分页查询参数
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RefundTaskDetailPageQueryParam extends PageQuery {

    /**
     * 关联扫描任务主键
     */
    private Long scanTaskId;

    /**
     * 支付业务单号
     */
    private String paymentOrderNo;

    /**
     * 执行状态
     */
    private Integer detailStatus;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 创建时间开始
     */
    private Date gmtCreateStart;

    /**
     * 创建时间结束
     */
    private Date gmtCreateEnd;

    /**
     * 修改时间开始
     */
    private Date gmtModifiedStart;

    /**
     * 修改时间结束
     */
    private Date gmtModifiedEnd;
}
