package cn.com.duiba.quanyi.center.api.dto.boc.szbl;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 深圳中行达标信息
 * @author cxw
 * @date 2025/09/23
 */
@Data
public class BocSzBlStandardResp implements Serializable {

    private static final long serialVersionUID = -2895377627323738850L;
    /**
     * 互联编号（切勿直接以此字段作为订单重复控制主键！！需与特活动提出业务确认！！）
     */
    private String serialId;

    /**
     * 校验类型
     * 1-活动对象(activityObject有值)
     * 2-达标对象(targetObject有值)
     * 3-活动对象+达标对象(均有值)
     */
    private String validType;

    /**
     * 渠道编号
     */
    private String channelId;

    /**
     * 活动编号
     */
    private String activityId;

    /**
     * 核⼼客⼾号
     */
    private String customerId;

    /**
     * 活动对象校验内容
     * 当validType为1或者3的时候返回数据有值
     * 0-未达标 1-达标
     */
    private String actObject;

    /**
     * 达标对象校验内容
     */
    private Map<String, BocSzTargetDetail> tarObject;
}
