package cn.com.duiba.quanyi.center.api.dto.invoice;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 外部发票表
 * @author xuzhigang
 * @date 2025-01-21
 */
@Data
public class InvoiceExternalDto implements Serializable {

    private static final long serialVersionUID = 8547293617582946L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 上传发票人ssoId
     */
    private Long createOperatorId;

    /**
     * 上传发票人ssoName
     */
    private String createOperatorName;

    /**
     * 发票金额
     */
    private Long invoiceAmount;

    /**
     * 发票附件
     */
    private String invoiceAttachmentUrl;

    /**
     * 转服务费凭证
     */
    private String invoiceCredentialUrl;

    /**
     * 开票时间
     */
    private Date invoiceIssueTime;

    /**
     * 兑吧主体id
     */
    private Long duibaSubjectId;

    /**
     * 关联业务id
     */
    private Long bizId;

    /**
     * 关联业务类型 1-保证金 2-供应商
     */
    private Integer bizType;
}
