package cn.com.duiba.quanyi.center.api.dto.payment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商付款记录与入库单关联关系
 * @author xuzhigang 
 * @date 2025-09-17 16:20
 */
@Data
public class PaymentInfoSupplierInboundDto implements Serializable {
     
    private static final long serialVersionUID = 17345671234567897L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 供应商付款ID
     */
    private Long supplierPaymentId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 入库单ID
     */
    private Long inboundOrderId;

    /**
     * 申请付款数量
     */
    private Long applyPaymentQty;

    /**
     * 申请付款金额
     */
    private Long applyPaymentAmount;
}
