package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 浦发账单表
 * @author mybatis generator 
 * @date 2025-05-07
 */
@Data
public class PuFaBillDto implements Serializable {
     
    private static final long serialVersionUID = 1746609956291527L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 1领卷 2核销 3退货
     */
    private Integer transType;

    /**
     * 三方奖品批次号
     */
    private String externalPrizeNo;

    /**
     * 卷码
     */
    private String couponCode;

    /**
     * 优惠卷名称
     */
    private String couponName;

    /**
     * 三方明细ID
     */
    private String externalDetailId;

    /**
     * 三方订单号
     */
    private String orderNo;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 优惠金额
     */
    private Long discountAmt;

    /**
     * 结算金额
     */
    private Long payAmount;

    /**
     * 状态更新时间yyyyMMddHHmmss
     */
    private String updateTime;

    /**
     * 01 可使用 02 已经使用 03 已过期 08 已废弃 11 已发放
     */
    private String status;

    /**
     * 有效期开始时间yyyyMMddHHmmss
     */
    private String validDate;

    /**
     * 有效期结束时间yyyyMMddHHmmss
     */
    private String invalidDate;

    /**
     * 核销定单号
     */
    private String chargesOrderNo;

    /**
     * 退款定单号
     */
    private String refundOrderNo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}