package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动奖品定时任务类型
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ActivityPrizeScheduledTaskBizTypeEnum {

    DEFAULT(0, "默认类型"),

    PRIZE_STOCK(1, "奖品库存"),
    ;


    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;


    public static ActivityPrizeScheduledTaskBizTypeEnum getByType(Integer type) {
        for (ActivityPrizeScheduledTaskBizTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
