package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author xuzhigang
 * @date 2024/8/29 16:16
 **/
@Getter
@AllArgsConstructor
public enum AlipayActivityAutoAddMoneyTypeEnum {
    CRON(1, "定时任务触发"),

    REALTIME(2, "库存扣减触发"),

    MANUAL(3, "聚宝盆后台手动触发"),

    INSURANCE(4, "保司自动加款"),
    ;
    private final int type;

    private final String desc;

    public static String getDescByType(Integer addType) {
        return Arrays.stream(values()).filter(t -> t.getType() == addType).findFirst().orElseThrow(() -> new RuntimeException("未找到对应的枚举")).getDesc();
    }
}
