package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author: LuHui
 * @date: 2024/6/28 14:27
 * @description:
 */
@Getter
@AllArgsConstructor
public enum InsuranceHarbinEquityTakeStatusEnum {

    WAIT(1, "待发放"),
    SUCCESS(2, "发放成功"),
    FAIL(3, "发放失败"),
    TAKE(4, "已兑换"),
    ;

    private final Integer status;

    private final String desc;

    public static InsuranceHarbinEquityTakeStatusEnum getByStatus(Integer status) {
        for (InsuranceHarbinEquityTakeStatusEnum statusEnum : InsuranceHarbinEquityTakeStatusEnum.values()) {
            if (Objects.equals(statusEnum.getStatus(), status)) {
                return statusEnum;
            }
        }
        return null;
    }


}
