package cn.com.duiba.quanyi.center.api.enums.invoice;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 外部发票关联业务类型枚举
 * @author xuzhigang
 * @date 2025-09-22 11:30
 */
@Getter
@AllArgsConstructor
public enum InvoiceExternalBizTypeEnum {
    DEPOSIT(1, "保证金"),
    SUPPLIER(2, "供应商"),
    ;

    private final Integer type;
    private final String desc;

    /**
     * 根据类型获取枚举
     * @param type 类型
     * @return 枚举
     */
    public static InvoiceExternalBizTypeEnum getEnum(Integer type) {
        if (type == null) {
            return null;
        }
        for (InvoiceExternalBizTypeEnum enumItem : InvoiceExternalBizTypeEnum.values()) {
            if (enumItem.getType().equals(type)) {
                return enumItem;
            }
        }
        return null;
    }

    /**
     * 根据类型获取描述
     * @param type 类型
     * @return 描述
     */
    public static String getDescByType(Integer type) {
        InvoiceExternalBizTypeEnum enumItem = getEnum(type);
        if (enumItem != null) {
            return enumItem.getDesc();
        }
        return null;
    }
}
