package cn.com.duiba.quanyi.center.api.enums.partner;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 联系方式枚举：1-手机号，2-微信
 */
@Getter
@AllArgsConstructor
public enum PartnerContactTypeEnum {
    PHONE(1, "手机"),
    WECHAT(2, "微信");

    private final Integer code;
    private final String desc;

    /**
     * 根据code获取desc
     * @param code 联系方式编码
     * @return 联系方式描述
     */
    public static String getDescByCode(Integer code) {
        for (PartnerContactTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type.getDesc();
            }
        }
        return null;
    }

    /**
     * 根据desc获取code
     * @param desc 联系方式描述
     * @return 联系方式编码
     */
    public static Integer getCodeByDesc(String desc) {
        for (PartnerContactTypeEnum type : values()) {
            if (type.getDesc().equals(desc)) {
                return type.getCode();
            }
        }
        return null;
    }
}
