package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 活动黑白名单表
 * @author mybatis generator
 * @date 2025-04-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ActivityBlackWhiteListSearchOffsetParam extends PageQuery{

    private static final long serialVersionUID = 17446989970573094L;

    /**
     * 类型：1-白名单，2-黑名单
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityBlackWhiteListTypeEnum
     */
    private Integer listType;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 用户唯一标记
     */
    private String userMark;

    /**
     * 上次最后一个id，第一页不传
     */
    private Long lastId;

    /**
     * 每页拉去的条数
     */
    private Integer pageSize;
}
