package cn.com.duiba.quanyi.center.api.param.payment;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 供应商付款记录与入库单关联关系查询参数
 * @author xuzhigang
 * @date 2025-10-10 15:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class PaymentInfoSupplierInboundSearchParam extends PageQuery {

    private static final long serialVersionUID = 8734512398756234891L;

    /**
     * 供应商付款ID
     */
    private Long supplierPaymentId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 入库单ID
     */
    private Long inboundOrderId;
}

