package cn.com.duiba.quanyi.center.api.remoteservice.financial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.financial.TaxCodeDto;
import cn.com.duiba.quanyi.center.api.param.financial.TaxCodeSearchParam;
import java.util.List;

/**
 * 税务编码
 * @author kjj mybatis generator 
 * @date 2024-12-02
 */
@AdvancedFeignClient
public interface RemoteTaxCodeService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 税务编码集合
     */
    List<TaxCodeDto> selectPage(TaxCodeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(TaxCodeSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 税务编码
     */
    TaxCodeDto selectById(Long id);

    /**
     * 根据主键集合查询
     * @param ids 主键集合
     * @return 税务编码
     */
    List<TaxCodeDto> selectByIds(List<Long> ids);

    /**
     * 新增
     * @param dto 税务编码
     * @return 执行结果
     */
    int insert(TaxCodeDto dto);

    /**
     * 更新
     * @param dto 税务编码
     * @return 影响行数
     */
    int update(TaxCodeDto dto);

    /**
     * 更新启用状态
     *
     * @param id           主键id
     * @param enableStatus 启用状态
     * @param oldStatus    更新前启用状态
     * @return 更新结果
     */
    int updateEnableStatus(Long id, Integer enableStatus, Integer oldStatus);
}