package cn.com.duiba.quanyi.center.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.task.ScheduledTaskRecordDto;
import cn.com.duiba.quanyi.center.api.param.task.ScheduledTaskRecordSearchParam;
import java.util.List;

/**
 * 定时任务记录表
 * @author kjj mybatis generator
 * @date 2025-06-11
 */
@AdvancedFeignClient
public interface RemoteScheduledTaskRecordService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 定时任务记录集合
     */
    List<ScheduledTaskRecordDto> selectPage(ScheduledTaskRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ScheduledTaskRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 定时任务记录
     */
    ScheduledTaskRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 定时任务记录
     * @return 执行结果
     */
    int insert(ScheduledTaskRecordDto dto);

    /**
     * 更新
     * @param dto 定时任务记录
     * @return 影响行数
     */
    int update(ScheduledTaskRecordDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据任务id查询
     * @param taskIds 任务id集合
     * @return 定时任务记录集合
     */
    List<ScheduledTaskRecordDto> selectByTaskIds(List<Long> taskIds);
}
