/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto;
import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonBlackWhiteUserMarkTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonErrorCodeEnum;
import cn.com.duiba.quanyi.center.api.enums.user.UserExtCommonKeyEnum;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;

public class ActivityCommonUtils {
    private ActivityCommonUtils() {
    }

    public static String getUserMark(ActivityCommonWhiteConfDto whiteConf, ActivityCommonBlackConfDto blackConf, Map<Integer, String> userExtMap) throws BizException {
        if (MapUtils.isEmpty(userExtMap)) {
            return null;
        }
        Integer userMarkType = ActivityCommonUtils.getUserMarkType(whiteConf, blackConf);
        if (userMarkType == null) {
            return null;
        }
        ActivityCommonBlackWhiteUserMarkTypeEnum userMarkTypeEnum = ActivityCommonBlackWhiteUserMarkTypeEnum.getByType(userMarkType);
        if (userMarkTypeEnum == null) {
            return null;
        }
        return userExtMap.get(userMarkTypeEnum.getExtCommonKey().getCode());
    }

    public static Integer getUserMarkType(ActivityCommonWhiteConfDto whiteConf, ActivityCommonBlackConfDto blackConf) throws BizException {
        Integer blackUserMarkType;
        Integer whiteUserMarkType = ActivityCommonUtils.isOpenWhiteList(whiteConf) ? whiteConf.getUserMarkType() : null;
        Integer n = blackUserMarkType = ActivityCommonUtils.isOpenBlackList(blackConf) ? blackConf.getUserMarkType() : null;
        if (whiteUserMarkType == null && blackUserMarkType == null) {
            return null;
        }
        if (whiteUserMarkType == null) {
            return blackUserMarkType;
        }
        if (blackUserMarkType == null) {
            return whiteUserMarkType;
        }
        if (!Objects.equals(whiteUserMarkType, blackUserMarkType)) {
            ActivityCommonErrorCodeEnum.AC000006.throwBiz();
            return null;
        }
        return whiteUserMarkType;
    }

    public static boolean isOpenWhiteList(ActivityCommonWhiteConfDto whiteConf) {
        if (whiteConf == null) {
            return false;
        }
        return BooleanEnum.TRUE.getCode().equals(whiteConf.getEnable());
    }

    public static boolean isOpenBlackList(ActivityCommonBlackConfDto blackConf) {
        if (blackConf == null) {
            return false;
        }
        return BooleanEnum.TRUE.getCode().equals(blackConf.getEnable());
    }

    public static Integer userMarkTypeToUserExtCommonKeyType(Integer userMarkType) {
        if (userMarkType == null) {
            return null;
        }
        if (Objects.equals(userMarkType, ActivityCommonBlackWhiteUserMarkTypeEnum.BOC_BANK_CLIENT_NUMBER.getType())) {
            return UserExtCommonKeyEnum.BANK_CLIENT_NUMBER.getCode();
        }
        if (Objects.equals(userMarkType, ActivityCommonBlackWhiteUserMarkTypeEnum.BOC_CORE_CLIENT_NUMBER.getType())) {
            return UserExtCommonKeyEnum.CORE_CLIENT_NUMBER.getCode();
        }
        return userMarkType;
    }
}

