/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class SerializableOptional<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -5017820068789758289L;
    private static final SerializableOptional<?> EMPTY = new SerializableOptional();
    private final T value;

    private SerializableOptional() {
        this.value = null;
    }

    public static <T extends Serializable> SerializableOptional<T> empty() {
        SerializableOptional<?> t = EMPTY;
        return t;
    }

    private SerializableOptional(T value) {
        this.value = (Serializable)Objects.requireNonNull(value);
    }

    public static <T extends Serializable> SerializableOptional<T> of(T value) {
        return new SerializableOptional<T>(value);
    }

    public static <T extends Serializable> SerializableOptional<T> ofNullable(T value) {
        return value == null ? SerializableOptional.empty() : SerializableOptional.of(value);
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public SerializableOptional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : SerializableOptional.empty();
    }

    public <U extends Serializable> SerializableOptional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return SerializableOptional.empty();
        }
        return SerializableOptional.ofNullable((Serializable)mapper.apply(this.value));
    }

    public <U extends Serializable> SerializableOptional<U> flatMap(Function<? super T, SerializableOptional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return SerializableOptional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return (T)(this.value != null ? this.value : (Serializable)other.get());
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SerializableOptional)) {
            return false;
        }
        SerializableOptional other = (SerializableOptional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("Optional[%s]", this.value) : "Optional.empty";
    }
}

