package cn.com.duiba.quanyi.center.api.dto.bigdata;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/3/5 13:54
 */
@Data
public class BigdataDownloadResultDto<T> implements Serializable {
    
    private static final long serialVersionUID = 6209920229893069090L;

    /**
     * 是否提交成功
     */
    private Boolean success;

    /**
     * 错误码
     */
    private String errCode;

    /**
     * 错误描述
     */
    private String errMsg;

    /**
     * 数据
     */
    private T data;
    
    public static <T> BigdataDownloadResultDto<T> success(T data) {
        BigdataDownloadResultDto<T> dto = new BigdataDownloadResultDto<>();
        dto.setSuccess(true);
        dto.setData(data);
        return dto;
    }
    
    public static <T> BigdataDownloadResultDto<T> fail(String errCode, String errMsg) {
        BigdataDownloadResultDto<T> dto = new BigdataDownloadResultDto<>();
        dto.setSuccess(false);
        dto.setErrCode(errCode);
        dto.setErrMsg(errMsg);
        return dto;
    }
}
