package cn.com.duiba.quanyi.center.api.param.cardsecret;

import java.io.Serializable;
import java.util.List;

import cn.com.duiba.quanyi.center.api.param.dayan.demand.DayanCardSecretStartRefundDetailParam;
import lombok.Data;

/**
 * 卡密回退参数（聚宝盆调用）
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@Data
public class CardSecretStartRefundParam implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 发起人ssoId
     */
    private Long ssoId;

    /**
     * 发起人钉钉用户id
     */
    private String dingTalkUserId;

    /**
     * 钉钉部门id
     */
    private Long dingTalkDeptId;

    /**
     * 需求商品id
     */
    private Long demandGoodsId;

    /**
     * 回退明细
     */
    private List<DayanCardSecretStartRefundDetailParam> refundDetailList;

    /**
     * 是否已结算：0-未结算，1-已结算
     */
    private Integer isSettled;

    /**
     * 回调topic(数字营销使用)
     */
    private String notifyTopic;

    /**
     * 回调tag(数字营销使用)
     */
    private String notifyTag;

    /**
     * 回调透传字段
     */
    private String notifyExt;
}

