package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author yinjiaqi
 * @date 2025-05-19 11:18:25
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class WxCouponPageEsParam extends PageQuery {
    private static final long serialVersionUID = 6238620672526962541L;

    /**
     * 批次号
     */
    private String stockId;
    /**
     * 创建人
     */
    private Long createOperatorId;
    /**
     * 批次号名称
     */
    private String stockName;
    /**
     * 制券商户
     */
    private String stockCreatorMchId;
    /**
     * 发券商户
     */
    private String mchId;
    /**
     * 批次类型
     */
    private Integer stockType;
    /**
     * 状态
     */
    private String stockStatus;
    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 项目商品id
     */
    private Long demandGoodsId;
    /**
     * 全部可发放商户号-单个精准匹配
     */
    private String sendMchId;

    /**
     * 业务状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockBizStatusEnum#getStatus()
     */
    private Integer bizStatus;
}
