package cn.com.duiba.quanyi.center.api.param.dayan.project;

import cn.com.duiba.quanyi.center.api.dto.project.ProjectGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectProductDto;
import cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2025/11/6 15:44
 **/
@Data
public class DayanProjectSaveParam implements Serializable {
    private static final long serialVersionUID = 8223205135258447464L;

    /**
     * 合同主键id
     */
    private Long id;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合作客户主键, tb_partner.id
     */
    private Long partnerId;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 合同编号
     */
    private String contractCode;

    /**
     * 合作开始时间
     */
    private Date startTime;

    /**
     * 合作结束时间
     */
    private Date endTime;

    /**
     * 合同运营，多个以英文逗号分隔
     */
    private List<Long> contractOperations;

    /**
     * 合同商务，多个以英文逗号分隔
     */
    private List<Long> contractCommerce;

    /**
     * 兑吧业务主体 tb_duiba_subject.id
     */
    private Long duibaSubject;

    /**
     * 合同类型 1-权益主合同 2-权益附属合同
     */
    private Integer contractType;

    /**
     * 主合同id 合同类型为权益附属合同时必填
     */
    private Long mainContractId;

    /**
     * 所属业务
     * @see cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum#getType()
     */
    private Integer belongingBusiness = BelongingBusinessTypeEnum.DIGITAL_MARKETING.getType();

    /**
     * 客户主体
     */
    private String partnerSubject;

    /**
     * 合同附件，多个文件逗号分割
     */
    private String contractAttachments;

    /**
     * 备注
     */
    private String contractRemark;

    /**
     * 归档方式 1-纸质版归档，2-邮件归档，3-电子版归档，4-直接打款归档
     */
    private Integer archiveType;

    /**
     * 是否需要打印 0-不需要 1-需要
     */
    private Integer needPrint;

    /**
     * 盖章类型 1-公章 2-法人章 3-合同章
     */
    private List<Integer> stampTypes;

    /**
     * 组合产品
     */
    private String productPortfolio;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 兑吧APPID
     */
    private String duibaAppId;

    /**
     * 兑吧账号主体
     * 1.兑吧 2.兑啊 3.客吉吉 4.安徽兑吧 5.其他
     * @see cn.com.duiba.quanyi.center.api.enums.contract.DuibaAccountSubjectEnum
     */
    private Integer duibaAccountSubject;

    /**
     * 项目关联商品信息
     */
    private List<ProjectGoodsDto> goodsList;

    /**
     * 项目关联产品信息
     */
    private List<ProjectProductDto> productList;

    /**
     * 合同运营姓名，多个以英文逗号分隔
     */
    private String contractOperationsName;

    /**
     * 合同商务姓名，多个以英文逗号分隔
     */
    private String contractCommerceName;

    /**
     * 合同金额类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer contractAmountType;

    /**
     * 是否提前开发
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer earlyDevelopment;

    /**
     * 是否有打折选择
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer discountOptions;

    /**
     * 标准合作类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer standardCooperationType;

    /**
     * 定制合作类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer customizedCooperationType;

    /**
     * 权益合作类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer purchaseCooperationType;

    /**
     * 签约对接人姓名
     */
    private String signContactsName;

    /**
     * 签约对接人联系方式
     */
    private String signContactsPhone;

    /******************项目信息******************/

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 商务负责人ID
     */
    private Long commerceManagerId;

    /**
     * 商务负责人姓名
     */
    private String commerceManagerName;

    /**
     * 运营负责人ID
     */
    private Long operationsManagerId;

    /**
     * 运营负责人姓名
     */
    private String operationsManagerName;

    /**
     * 回款超期天数
     */
    private Integer receivedOverdueDays;

    /**
     * 权益产品金额
     */
    private Long purchaseAmount;
}
