package cn.com.duiba.quanyi.center.api.param.demand;

import cn.com.duiba.quanyi.center.api.dto.demand.DemandContractRefDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2025/10/17 15:04
 **/
@Data
public class DemandBudgetWithFeeUpdateParam implements Serializable {
    private static final long serialVersionUID = -3041892457128799597L;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 修改前需求预算
     */
    private Long originDemandBudgetWithFee;

    /**
     * 修改后需求预算
     */
    private Long newDemandBudgetWithFee;

    /**
     * 需求合同关联信息 追加合同金额
     */
    private List<DemandContractRefDto> refList;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 凭证文件
     */
    private List<String> credentialFiles;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;
}
