package cn.com.duiba.quanyi.center.api.param.refund;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import java.io.Serializable;

/**
 * 退款审批参数
 *
 * @author yangyukang
 * @date 2025/1/21
 */
@Data
public class RefundApprovalParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 退款总金额，单位为分
     */
    @NotNull(message = "退款总金额不能为空")
    @Positive(message = "退款总金额必须大于0")
    private Long totalRefundAmount;

    /**
     * 退款原因
     */
    @NotBlank(message = "退款原因不能为空")
    private String refundReason;

    /**
     * 文件URL
     */
    private String fileUrl;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 上传任务ID
     */
    private Long uploadTaskId;

    /**
     * 操作人sso用户ID
     */
    @NotNull(message = "操作人ID不能为空")
    private Long operatorSsoId;

    /**
     * 操作人sso姓名
     */
    @NotBlank(message = "操作人姓名不能为空")
    private String operatorSsoName;

    /**
     * 钉钉用户ID
     */
    private String dingTalkUserId;

    /**
     * 钉钉部门ID
     */
    private Long dingTalkDeptId;

    /**
     * 审批额外参数extParam
     */
    private String extParam;
}
