package cn.com.duiba.quanyi.center.api.remoteservice.activity.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.collection.ActivityCommonUserCustomVerifyCollectionPageDto;

import java.util.concurrent.TimeUnit;

/**
 * @author lizhi
 * @date 2025/4/30 16:46
 */
@AdvancedFeignClient
public interface RemoteActivityCommonUserCustomVerifyCollectionPageService {

    /**
     * 查询用户验证结果
     * @param userId 用户ID
     * @param collectionPageId 集合页ID
     * @return 验证结果
     */
    ActivityCommonUserCustomVerifyCollectionPageDto get(Long userId, Long collectionPageId);

    /**
     * 设置用户验证结果
     * @param userId 用户ID
     * @param collectionPageId 集合页ID
     * @param dto 结果
     * @param timeout 缓存时间
     * @param unit 时间单位
     * @return 是否成功
     */
    boolean set(Long userId, Long collectionPageId, ActivityCommonUserCustomVerifyCollectionPageDto dto, int timeout, TimeUnit unit);
}
