package cn.com.duiba.quanyi.center.api.remoteservice.demand.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.task.ChangeSkuBatchTaskDto;
import cn.com.duiba.quanyi.center.api.param.demand.task.ChangeSkuParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 批量更改sku批次表
 * @author kjj mybatis generator 
 * @date 2025-02-17
 */
@AdvancedFeignClient
public interface RemoteChangeSkuBatchTaskService {
    /**
     * 批量新增
     * @param insertList 待插入数据
     * @return 执行结果
     */
    int batchInsert(List<ChangeSkuBatchTaskDto> insertList);

    /**
     * 更改sku
     * @param param 参数
     * @return 成功数量
     */
    int changeSku(ChangeSkuParam param);

    /**
     * 根据changeSkuTaskId查询
     * @param changeSkuTaskId 主任务id
     * @return 批量更改sku批次集合
     */
    List<ChangeSkuBatchTaskDto> selectByChangeSkuTaskId(Long changeSkuTaskId);
}