package cn.com.duiba.quanyi.center.api.remoteservice.questionnaire;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.questionnaire.QuestionnaireDto;
import cn.com.duiba.quanyi.center.api.param.questionnaire.QuestionnaireSearchParam;
import java.util.List;

/**
 * 问卷
 * @author kjj mybatis generator
 * @date 2025-10-28
 */
@AdvancedFeignClient
public interface RemoteQuestionnaireService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 问卷集合
     */
    List<QuestionnaireDto> selectPage(QuestionnaireSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(QuestionnaireSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 问卷
     */
    QuestionnaireDto selectById(Long id);

    /**
     * 新增
     * @param dto 问卷
     * @return 执行结果
     */
    int insert(QuestionnaireDto dto);

    /**
     * 更新
     * @param dto 问卷
     * @return 影响行数
     */
    int update(QuestionnaireDto dto);
}
