package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementPreDetailDto;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementPreDetailFillAmountParam;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementPreLockOrUnlockParam;

import java.util.List;

/**
 * 结算单预结算明细
 * @author kjj mybatis generator
 * @date 2025-11-11
 */
@AdvancedFeignClient
public interface RemoteSettlementPreDetailService {

    /**
     * 根据结算单ID查询
     * @param settlementId 结算单ID
     * @return 结算单预结算明细集合
     */
    List<SettlementPreDetailDto> selectBySettlementId(Long settlementId);

    /**
     * 根据ID批量查询
     * @param ids 主键集合
     * @return 结算单预结算明细集合
     */
    List<SettlementPreDetailDto> selectByIds(List<Long> ids);

    /**
     * 批量锁定或解锁需求明细
     * @param lockOrUnlockParamList 锁定或解锁参数集合
     * @return 执行结果
     */
    boolean batchLockOrUnlock(List<SettlementPreLockOrUnlockParam> lockOrUnlockParamList);

    /**
     * 批量回填开票金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillInvoicedAmount(List<SettlementPreDetailFillAmountParam> list);

    /**
     * 批量回填回款金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillReceivedAmount(List<SettlementPreDetailFillAmountParam> list);
}
