package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.ActivityLimitConfigEnum;
import lombok.Data;

import java.io.Serializable;


/**
 * 活动助力配置
 *
 * @author wangguanhua
 */
@Data
public class ActivityHelpConfigDto implements Serializable {

    private static final long serialVersionUID = -4493834600089202101L;

    /**
     * 参与限制，0-无，1-邀请助力
     */
    private Integer joinLimit;

    /**
     * 邀请者被助力次数限制
     */
    private Integer inviterHelpedTimeLimit;

    /**
     * 邀请者被助力次数限制，分每天、每周、每月、永久
     *
     * @see ActivityLimitConfigEnum#getType()
     */
    private Integer inviterHelpedTimeLimitType;

    /**
     * 被邀请者被助力次数限制
     */
    private Integer inviteeHelpedTimeLimit;

    /**
     * 被邀请者被助力次数限制类型，分每天、每周、每月、永久
     *
     * @see ActivityLimitConfigEnum#getType()
     */
    private Integer inviteeHelpedTimeLimitType;

    /**
     * 同一用户被助力次数限制
     */
    private Integer sameUserHelpedTimeLimit;

    /**
     * 同一用户被助力次数限制类型，分每天、每周、每月、永久
     *
     * @see ActivityLimitConfigEnum#getType()
     */
    private Integer sameUserHelpedTimeLimitType;

    /**
     * 助力次数转化中奖次数：助力x次转化为1次抽奖/领奖次数
     */
    private Integer helpedTimeToDrawTime;
}