package cn.com.duiba.quanyi.center.api.dto.activity.common.cache;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/4/30 15:41
 */
@AllArgsConstructor
@Getter
public enum ActivityCommonCacheTypeEnum {
    RECEIVE_RECORD(1, "领取记录"),
    USER_TAKE_STAT(2, "用户领取记录统计"),
    USER(3, "用户信息"),
    USER_EXT(4, "用户扩展信息"),
    USER_API_VERIFY(5, "用户身份校验结果（API）"),
    USER_CUSTOM_VERIFY(6, "用户身份校验结果（定制校验）"),
    API_REACH_STANDARD(7, "达标等级（API）"),
    SIGN_UP_LIST(8, "报名记录"),
    SIGN_UP_CUSTOM_VERIFY(9, "报名定制验证结果"),
    LAST_PAY_ORDER(10, "最近一次处理中支付记录"),
    PAY_ORDER_VOUCHER(11, "支付领取凭证"),


    // 集合页
    COLLECTION_PAGE_USER_TAKE_STAT(51, "集合页-用户领取记录统计"),
    COLLECTION_PAGE_USER_API_VERIFY(52, "集合页-用户身份校验结果（API）"),
    COLLECTION_PAGE_USER_CUSTOM_VERIFY(53, "集合页-用户身份校验结果（定制校验）"),
    COLLECTION_PAGE_SIGN_UP_LIST(54, "集合页-报名记录"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, ActivityCommonCacheTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityCommonCacheTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static ActivityCommonCacheTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
