package cn.com.duiba.quanyi.center.api.dto.demand;

import cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 需求变更记录表
 *
 * @author xuzhigang
 * @date 2025-07-07
 */
@Data
public class DemandChangeRecordDto implements Serializable {

    private static final long serialVersionUID = 7392847561829374650L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 变更类型 1-新增需求 2-新增需求商品 3-修改需求预算
     */
    private Integer changeType;

    /**
     * 审批状态
     *
     * @see ApprovalStatusEnum
     */
    private Integer approvalStatus;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 操作人sso用户ID
     */
    private Long operatorSsoId;

    /**
     * 操作人sso姓名
     */
    private String operatorSsoName;

    /**
     * 数量
     */
    private Integer totalNum;

    /**
     * 成功数量
     */
    private Integer successNum;

    /**
     * 失败数量
     */
    private Integer failureNum;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 修改凭证文件
     */
    private String credentialFiles;

    /**
     * 变更记录明细
     */
    private String changeRecordDetail;

    /**
     * 变更参数JSON
     */
    private String changeParam;

    /**
     * 操作人钉钉用户id
     */
    private String dingTalkUserId;

    /**
     * 操作人部门id
     */
    private Long dingTalkDeptId;

    /**
     * 开票申请id
     */
    private Long invoiceApplyId;
}
