package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 运营工作台-消耗数据基础表
 * @author mybatis generator
 * @date 2025-06-05
 */
@Data
public class ConsumeDailyDataDto implements Serializable {

    private static final long serialVersionUID = 17491220265348672L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 1：活动id字符串，2.奖品id字符串以此类推
     */
    private String statId;

    /**
     * 统计类型
     * @see cn.com.duiba.quanyi.center.api.enums.statistic.ConsumeStatisitcTypeEnum
     */
    private Integer statType;

    /**
     * 消耗数
     */
    private Long consumedNum;

    /**
     * 统计日
     */
    private Date statDate;

    /**
     * 对应活动、奖品、需求...创建人id
     */
    private Long createOperatorId;

    /**
     * 活动类型
     * @see BizActTypeEnum
     */
    private Integer activityType;
}
