package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 领取时间限制类型枚举
 * 
 * @author yangyukang
 * @date 2025-01-21
 */
@Getter
@AllArgsConstructor
public enum ClaimTimeLimitTypeEnum {
    
    /**
     * 不限制
     */
    NO_LIMIT(0, "不限制"),
    
    /**
     * 最晚可领取时间
     */
    LATEST_CLAIM_TIME(1, "最晚可领取时间"),
    
    /**
     * 订单生成后x天内可领取
     */
    DAYS_AFTER_ORDER(2, "订单生成后x天内可领取"),
    
    /**
     * 订单生成后当月x号内领取
     */
    MONTH_DAY_AFTER_ORDER(3, "订单生成后当月x号内领取"),
    
    /**
     * 订单生成后当季度可领取
     */
    QUARTER_AFTER_ORDER(4, "订单生成后当季度可领取"),
    
    /**
     * 自定义时间
     */
    CUSTOM_TIME(5, "自定义时间");
    
    private final Integer type;
    
    private final String desc;
    
    public static ClaimTimeLimitTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ClaimTimeLimitTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }
}

