package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 合同消耗明细排序类型枚举
 *
 * @author xuzhigang
 * @date 2025-06-05
 */
@Getter
@AllArgsConstructor
public enum ContractConsumeDetailSortTypeEnum {

    /**
     * 根据超出金额升序
     */
    OVER_AMOUNT_ASC(1, "根据超出金额升序"),

    /**
     * 根据超出金额降序
     */
    OVER_AMOUNT_DESC(2, "根据超出金额降序");

    /**
     * 类型值
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据类型获取枚举
     *
     * @param type 类型值
     * @return 枚举
     */
    public static ContractConsumeDetailSortTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ContractConsumeDetailSortTypeEnum sortType : values()) {
            if (sortType.getType().equals(type)) {
                return sortType;
            }
        }
        return null;
    }

    /**
     * 获取排序SQL片段
     *
     * @param type 排序类型
     * @return SQL排序片段
     */
    public static String getSortSql(Integer type) {
        ContractConsumeDetailSortTypeEnum sortTypeEnum = getByType(type);
        if (sortTypeEnum == null) {
            return "gmt_create desc"; // 默认按创建时间降序
        }

        switch (sortTypeEnum) {
            case OVER_AMOUNT_ASC:
                return "over_amount asc, gmt_create desc";
            case OVER_AMOUNT_DESC:
                return "over_amount desc, gmt_create desc";
            default:
                return "gmt_create desc";
        }
    }
}