package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author xuzhigang
 * @date 2024/4/29 14:14
 **/
@Getter
@AllArgsConstructor
public enum WxCouponAutoAddMoneyTypeEnum {
    CRON(1, "定时任务触发"),

    REALTIME(2, "库存扣减触发"),

    MANUAL(3, "聚宝盆后台手动触发"),

    UPLOAD(4, "聚宝盆后台批量触发"),
    CRON_CONSUME_STOCK_THRESHOLD(5, "定时任务触发-微信消耗库存低于阈值"),
    CRON_UPDATE_PAUSE_STOCK(6, "定时任务触发-修改暂停批次号库存"),
    CUT_TO_10X_COUPON_AMOUNT(7, "消耗不达标，改为10倍面额预算"),
    ;

    private final int type;

    private final String desc;

    public static String getDescByType(Integer addType) {
        return Arrays.stream(values()).filter(t -> t.getType() == addType).findFirst().orElseThrow(() -> new RuntimeException("未找到对应的枚举")).getDesc();
    }

    static {
        checkRepeat();
    }

    /**
     * type重复检测
     */
    public static void checkRepeat() {
        long count = Arrays.stream(values()).map(WxCouponAutoAddMoneyTypeEnum::getType).distinct().count();
        if (count != values().length) {
            throw new RuntimeException("WxCouponAutoAddMoneyTypeEnum.type重复");
        }
    }
}
