package cn.com.duiba.quanyi.center.api.enums.demand;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * Created by dugq on 2025/12/2.
 */

@Getter
@AllArgsConstructor
public enum DeliveryConfigTypeEnum {

    UNKNOW(0, "未知", 0),
    /**
     * 垫资
     */
    ADVANCE_FUNDING(1, "垫资", 5),

    /**
     * 满减
     */
    FULL_REDUCTION(2, "满减", 10),

    /**
     * API/链接券
     */
    API_COUPON(3, "api/链接券", 10),

    /**
     * 券包
     */
    COUPON_PACKAGE(4, "券包", 20),

    /**
     * 兑吧H5模板活动
     */
    DUIBA_H5_TEMPLATE(5, "兑吧H5模板活动",40),

    /**
     * 兑吧定制活动
     */
    DUIBA_CUSTOM(6, "兑吧定制活动", 80);

    private final int code;
    private final String desc;
    private final int time; // 工时(小时*10，便于整数计算)

    /**
     * 根据code获取枚举
     */
    public static DeliveryConfigTypeEnum getByCode(Integer code) {
        if (code == null) {
            return UNKNOW;
        }
        for (DeliveryConfigTypeEnum type : values()) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return UNKNOW;
    }


}
