package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayActivityBizStatusEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author yinjiaqi
 * @date 2025-06-19 18:14:59
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AliPayCountCoinsBindGoodsSearchParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 1122785217528891863L;
    /**
     * 支付宝数币红包活动ID
     */
    private String alipayActId;
    /**
     * 面额，单位分
     */
    private Long discountValue;

    /**
     * 业务状态：1-待分配, 2-已分配
     * {@link AlipayActivityBizStatusEnum}
     */
    private Integer bizStatus;

    /**
     * 支付宝数币活动状态
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer alipayActStatus;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private Long demandGoodsId;
}
